<?php

/** @var \yii\web\View $this */
/** @var string $content */

use common\assets\AppAsset;
use common\widgets\Alert;
use yii\bootstrap5\Html;
use yii\helpers\Url;

AppAsset::register($this);
$controllerId = Yii::$app->controller->id;
$rawMenu = [
    ['label' =>  Yii::t('app', 'Home Page'), 'url' => ['/site']],
    ['label' => Yii::t('app', 'Admissions'), 'url' => ['/registration']],
];
$menuItems = array_filter($rawMenu, fn($v) => $v !== null);

?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">

<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>

<body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <?php $this->beginBody() ?>
    <div class="app-wrapper">
        <!-- Header -->
        <nav class="app-header navbar navbar-expand bg-body">
            <div class="container-fluid">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button">
                            <i class="bi bi-list"></i>
                        </a>
                    </li>
                    <li class="nav-item d-none d-md-block"><a href="<?= Yii::$app->homeUrl ?>" class="nav-link">หน้าหลัก</a></li>
                </ul>
                <ul class="navbar-nav ms-auto">
                    <?php if (!Yii::$app->user->isGuest): ?>
                        <?php
                            $usr_image = Yii::$app->user->identity->id_admission_prefix%2 == 1 ? '@web/images/male.png' : '@web/images/female.png';
                            
                            ?>
                        <li class="nav-item dropdown user-menu">
                            <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                <?= Html::img($usr_image, ['class' => 'user-image rounded-circle shadow', 'alt' => 'User Image']) ?>
                                <span class="d-none d-md-inline"><?= Yii::$app->user->identity->first_name ?> <?= Yii::$app->user->identity->last_name ?></span>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                                <!--begin::User Image-->
                                <li class="user-header text-bg-primary">
                                    <?= Html::img($usr_image, ['class' => 'rounded-circle shadow', 'alt' => 'User Image']) ?>
                                    <p>
                                        <?= Yii::$app->user->identity->first_name ?> <?= Yii::$app->user->identity->last_name ?>
                                        <small><?= Yii::t('app', 'Member since {date}', ['date' => Yii::$app->formatter->asDate(Yii::$app->user->identity->created_at, 'php:M. Y')]) ?></small>
                                    </p>
                                </li>
                                <!--begin::Menu Footer-->
                                <li class="user-footer">
                                    <?= Html::a(Yii::t('app', 'Profile'), ['/profile'], ['class' => 'btn btn-default btn-flat']) ?>
                                    <?= Html::a(Yii::t('app', 'Sign out'), ['/site/logout'], ['class' => 'btn btn-default btn-flat float-end', 'data-method' => 'post']) ?>
                                </li>
                                <!--end::Menu Footer-->
                            </ul>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </nav>

        <!-- Sidebar -->
        <aside class="app-sidebar bg-body-secondary shadow" data-bs-theme="dark">
            <div>
                <a href="<?= Yii::$app->homeUrl ?>" class="brand-link">
                    <?= Html::img('@web/images/logo.jpg', ['class' => 'brand-image opacity-75 shadow img-fluid', 'alt' => 'Logo']) ?>
                </a>
            </div>

            <div class="sidebar-wrapper">
                <nav class="mt-2">
                    <ul class="nav sidebar-menu flex-column"
                        data-lte-toggle="treeview"
                        role="menu"
                        data-accordion="false">

                        <?php foreach ($menuItems as $item): ?>
                            <?php if (isset($item['items'])): ?>
                                <?php
                                // ตรวจสอบว่า dropdown นี้มีเมนูย่อยใด active ไหม
                                $parentActive = false;
                                foreach ($item['items'] as $sub) {
                                    if ($controllerId === trim($sub['url'][0], '/')) {
                                        $parentActive = true;
                                        break;
                                    }
                                }
                                ?>
                                <li class="nav-item <?= $parentActive ? 'menu-open' : '' ?>">
                                    <a href="#" class="nav-link <?= $parentActive ? 'active' : '' ?>">
                                        <i class="nav-icon bi bi-circle-fill"></i>
                                        <p>
                                            <?= Html::encode($item['label']) ?>
                                            <i class="nav-arrow bi bi-chevron-right"></i>
                                        </p>
                                    </a>
                                    <ul class="nav nav-treeview" style="display: <?= $parentActive ? 'block' : 'none' ?>;">
                                        <?php foreach ($item['items'] as $sub): ?>
                                            <?php $active = $controllerId === trim($sub['url'][0], '/'); ?>
                                            <li class="nav-item">
                                                <a href="<?= Url::to($sub['url']) ?>" class="nav-link <?= $active ? 'active' : '' ?>">
                                                    <i class="nav-icon bi bi-circle"></i>
                                                    <p><?= Html::encode($sub['label']) ?></p>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </li>
                            <?php else: ?>
                                <?php $active = $controllerId === trim($item['url'][0], '/'); ?>
                                <li class="nav-item">
                                    <a href="<?= Url::to($item['url']) ?>" class="nav-link <?= $active ? 'active' : '' ?>">
                                        <i class="nav-icon bi bi-circle-fill"></i>
                                        <p><?= Html::encode($item['label']) ?></p>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; ?>

                    </ul>
                </nav>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="app-main">
            <div class="app-content-header">
                <div class="container-fluid">
                    <?php
                    if (!empty($this->params['hideTitle']) == false):
                    ?>
                        <div class="row">
                            <div class="col-sm-6">
                                <h3 class="mb-0"><?= Html::encode($this->title) ?></h3>
                            </div>
                            <div class="col-sm-6">
                                <ol class="breadcrumb float-sm-end">
                                    <?php foreach ($this->params['breadcrumbs'] ?? [] as $breadcrumb): ?>
                                        <li class="breadcrumb-item"><?= is_array($breadcrumb) ? Html::a($breadcrumb['label'], $breadcrumb['url']) : $breadcrumb ?></li>
                                    <?php endforeach ?>
                                </ol>
                            </div>
                        </div>
                    <?php
                    endif;
                    ?>
                </div>
            </div>
            <div class="app-content">
                <div class="container-fluid">
                    <?= Alert::widget() ?>
                    <?= $content ?>
                </div>
            </div>
        </main>

        <!-- Footer -->
        <footer class="app-footer">
            <div class="float-end d-none d-sm-inline">Anything you want</div>
            <strong>
                &copy; <?= date('Y') ?> <?= Html::encode(Yii::$app->name) ?>.
            </strong> All rights reserved.
        </footer>

    </div>
    <?php $this->endBody() ?>
</body>

</html>
<?php $this->endPage();
